% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

RBC_table_data = [  corr(log(C_t),log(Y_t)), ...
                    corr(log(I_t),log(Y_t)), ...
                    corr(log(C_t),log(I_t)), ...
                    corr(log(SR_t),log(Y_t)), ...
                    corr(log(Y_t),log(PI_t)), ...
                    std(log(C_t)) / std(log(Y_t)), ...
                    std(log(I_t)) / std(log(Y_t))];

writematrix(RBC_table_data,sprintf('%s/Table4_data_RBC.csv',PARMS.tabfolder))

clear RBC_table_data